// Code generated by goctl. DO NOT EDIT.

package model

import (
	"context"
	"database/sql"
	"fmt"
	"strings"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	sysUsersFieldNames          = builder.RawFieldNames(&SysUsers{})
	sysUsersRows                = strings.Join(sysUsersFieldNames, ",")
	sysUsersRowsExpectAutoSet   = strings.Join(stringx.Remove(sysUsersFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	sysUsersRowsWithPlaceHolder = strings.Join(stringx.Remove(sysUsersFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	sysUsersModel interface {
		Insert(ctx context.Context, data *SysUsers) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*SysUsers, error)
		FindOneByEmail(ctx context.Context, email string) (*SysUsers, error)
		FindOneByNickName(ctx context.Context, nickName string) (*SysUsers, error)
		FindOneByPhone(ctx context.Context, phone sql.NullString) (*SysUsers, error)
		FindOneByUsername(ctx context.Context, username string) (*SysUsers, error)
		FindOneByUuid(ctx context.Context, uuid sql.NullString) (*SysUsers, error)
		Update(ctx context.Context, data *SysUsers) error
		Delete(ctx context.Context, id uint64) error
		ListUsers(ctx context.Context, role string) ([]*SysUsers, error)	
	}
	defaultSysUsersModel struct {
		conn  sqlx.SqlConn
		table string
	}

	SysUsers struct {
		Id          uint64         `db:"id"`
		CreatedAt   sql.NullTime   `db:"created_at"`
		UpdatedAt   sql.NullTime   `db:"updated_at"`
		DeletedAt   sql.NullTime   `db:"deleted_at"`
		Uuid        sql.NullString `db:"uuid"`         // 用户UUID
		Username    string         `db:"username"`     // 用户登录名
		Password    string         `db:"password"`     // 用户登录密码
		NickName    string         `db:"nick_name"`    // 用户昵称
		SideMode    string         `db:"side_mode"`    // 用户侧边主题
		HeaderImg   string         `db:"header_img"`   // 用户头像
		BaseColor   string         `db:"base_color"`   // 基础颜色
		ActiveColor string         `db:"active_color"` // 活跃颜色
		AuthorityId uint64         `db:"authority_id"` // 用户角色ID
		Phone       sql.NullString `db:"phone"`        // 用户手机号
		Email       string         `db:"email"`        // 用户邮箱
		Role        string         `db:"role"`         // 用户初始角色
		Enable      int64          `db:"enable"`       // 用户是否被冻结 1正常 2冻结
	}
)

func newSysUsersModel(conn sqlx.SqlConn) *defaultSysUsersModel {
	return &defaultSysUsersModel{
		conn:  conn,
		table: "`sys_users`",
	}
}

func (m *defaultSysUsersModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultSysUsersModel) FindOne(ctx context.Context, id uint64) (*SysUsers, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", sysUsersRows, m.table)
	var resp SysUsers
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultSysUsersModel) FindOneByEmail(ctx context.Context, email string) (*SysUsers, error) {
	var resp SysUsers
	query := fmt.Sprintf("select %s from %s where `email` = ? limit 1", sysUsersRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, email)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultSysUsersModel) FindOneByNickName(ctx context.Context, nickName string) (*SysUsers, error) {
	var resp SysUsers
	query := fmt.Sprintf("select %s from %s where `nick_name` = ? limit 1", sysUsersRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, nickName)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultSysUsersModel) FindOneByPhone(ctx context.Context, phone sql.NullString) (*SysUsers, error) {
	var resp SysUsers
	query := fmt.Sprintf("select %s from %s where `phone` = ? limit 1", sysUsersRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, phone)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultSysUsersModel) FindOneByUsername(ctx context.Context, username string) (*SysUsers, error) {
	var resp SysUsers
	query := fmt.Sprintf("select %s from %s where `username` = ? and enable = 1 limit 1", sysUsersRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, username)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultSysUsersModel) FindOneByUuid(ctx context.Context, uuid sql.NullString) (*SysUsers, error) {
	var resp SysUsers
	query := fmt.Sprintf("select %s from %s where `uuid` = ? limit 1", sysUsersRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, uuid)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultSysUsersModel) Insert(ctx context.Context, data *SysUsers) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, sysUsersRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.DeletedAt, data.Uuid, data.Username, data.Password, data.NickName, data.SideMode, data.HeaderImg, data.BaseColor, data.ActiveColor, data.AuthorityId, data.Phone, data.Email, data.Role, data.Enable)
	return ret, err
}

func (m *defaultSysUsersModel) Update(ctx context.Context, newData *SysUsers) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, sysUsersRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, newData.DeletedAt, newData.Uuid, newData.Username, newData.Password, newData.NickName, newData.SideMode, newData.HeaderImg, newData.BaseColor, newData.ActiveColor, newData.AuthorityId, newData.Phone, newData.Email, newData.Role, newData.Enable, newData.Id)
	return err
}

func (m *defaultSysUsersModel) ListUsers(ctx context.Context, role string) ([]*SysUsers, error) {
	var query string
	if role == "" {
    	query = fmt.Sprintf("select %s from %s where enable = 1", sysUsersRows, m.table)
	} else {
		query = fmt.Sprintf("select %s from %s where enable = 1 and `role` = %s", sysUsersRows, m.table, role)
	}
    var resp []*SysUsers
    err := m.conn.QueryRows(&resp, query)
    if err != nil {
        return nil, err
    }
    return resp, nil
}

func (m *defaultSysUsersModel) tableName() string {
	return m.table
}
