package logic

import (
	"context"
	"strconv"

	"oa-server/app/usercenter/rpc/internal/svc"
	"oa-server/app/usercenter/rpc/pb/usercenter"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetUserListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetUserListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetUserListLogic {
	return &GetUserListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetUserListLogic) GetUserList(in *usercenter.UserListRequest) (*usercenter.UserListResponse, error) {
	userList, err := l.svcCtx.UserModel.ListUsers(l.ctx, in.Role)
	if err != nil {
		return nil, err
	}

	response := &usercenter.UserListResponse{}
	for _, user := range userList {
		authID := strconv.FormatUint(user.AuthorityId, 10)
		response.UserList = append(response.UserList, &usercenter.UserInfo{
			Id:       user.Id,
			Nickname: user.NickName,
			Email:    user.Email,
			Role:     authID,
		})
	}
	return response, nil
}
