package logic

import (
	"context"
	"strconv"

	"oa-server/app/usercenter/rpc/internal/svc"
	"oa-server/app/usercenter/rpc/pb/usercenter"
	"oa-server/common/tool"
	"oa-server/common/xerr"

	"github.com/zeromicro/go-zero/core/logx"
)

type LoginLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

var ErrUsernamePwdError = xerr.NewErrMsg("账号或密码不正确")

func NewLoginLogic(ctx context.Context, svcCtx *svc.ServiceContext) *LoginLogic {
	return &LoginLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *LoginLogic) Login(in *usercenter.LoginRequest) (*usercenter.LoginResponse, error) {
	user, err := l.svcCtx.UserModel.FindOneByUsername(l.ctx, in.Username)
	if err != nil {
		return nil, err
	}
	// 判断下密码是否正确
	if !tool.BcryptCheck(in.Password, user.Password) {
		return nil, ErrUsernamePwdError
	}
	// uint转string
	authID := strconv.FormatUint(user.AuthorityId, 10)
	return &usercenter.LoginResponse{
		Id:       user.Id,
		Nickname: user.NickName,
		Email:    user.Email,
		Role:     authID,
	}, nil
}
