package logic

import (
	"context"
	"database/sql"
	"time"

	"oa-server/app/usercenter/model"
	"oa-server/app/usercenter/rpc/internal/svc"
	"oa-server/app/usercenter/rpc/pb/usercenter"
	"oa-server/common/tool"

	uuid "github.com/satori/go.uuid"
	"github.com/zeromicro/go-zero/core/logx"
)

type RegisterLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewRegisterLogic(ctx context.Context, svcCtx *svc.ServiceContext) *RegisterLogic {
	return &RegisterLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *RegisterLogic) Register(in *usercenter.RegisterRequest) (*usercenter.CommonResponse, error) {
	uid := sql.NullString{
		String: uuid.NewV4().String(),
		Valid:  true,
	}
	nowTime := sql.NullTime{
		Time:  time.Now(),
		Valid: true,
	}
	phone := sql.NullString{
		String: in.Phone,
		Valid:  true,
	}
	user := model.SysUsers{
		Username:    in.Username,
		Password:    tool.BcryptHash(in.Password),
		Email:       in.Email,
		AuthorityId: in.AuthorityId,
		Uuid:        uid,
		CreatedAt:   nowTime,
		UpdatedAt:   nowTime,
		NickName:    in.Username,
		SideMode:    "dark",
		ActiveColor: "#1890ff",
		HeaderImg:   "https://qmplusimg.henrongyi.top/gva_header.jpg",
		BaseColor:   "#fff",
		Phone:       phone,
		Enable:      1,
		Role:        "2",
	}
	_, err := l.svcCtx.UserModel.Insert(l.ctx, &user)
	if err != nil {
		return nil, err
	}
	return &usercenter.CommonResponse{}, nil
}
