package ctxdata

import (
	"context"
	"encoding/json"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

// CtxKeyJwtUserId get uid from ctx
type ContextKey string

var CtxKeyJwtUserId ContextKey = "jwtUserId"
var CtxKeyJwtUserRole ContextKey = "jwtUserRole"
var CtxKeyJwtUserEmail ContextKey = "jwtUserEmail"
var CtxKeyJwtUserInfo ContextKey = "jwtUserInfo"
var CtxKeyAcceptLanguage ContextKey = "acceptLanguage"
var CtxKeyClientType ContextKey = "clientType"

func GetUserInfoFromCtx(ctx context.Context) usercenter.PublicLbkUserOutside {
	userInfo := ctx.Value(CtxKeyJwtUserInfo).(usercenter.PublicLbkUserOutside)
	return userInfo
}

func GetUidFromCtx(ctx context.Context) int64 {
	var uid int64
	if jsonUid, ok := ctx.Value(CtxKeyJwtUserId).(json.Number); ok {
		if int64Uid, err := jsonUid.Int64(); err == nil {
			uid = int64Uid
		} else {
			logx.WithContext(ctx).Errorf("GetUidFromCtx err : %+v", err)
		}
	}
	return uid
}

type UserCtx struct {
	UserId uint64
	Role   string
	Email  string
}

func GetUserFromCtx(ctx context.Context) *UserCtx {
	var uid uint64
	var role string
	var email string
	// a := ctx.Value(CtxKeyJwtUserId)
	// b := ctx.Value(CtxKeyJwtUserRole)
	// fmt.Printf("a is %+v\n", a)
	// fmt.Printf("b is %+v\n", b)
	// get uid and role from ctx by CtxKeyJwtUserId CtxKeyJwtUserRole
	if jsonUid, ok := ctx.Value(CtxKeyJwtUserId).(json.Number); ok {
		if int64Uid, err := jsonUid.Int64(); err == nil {
			uid = uint64(int64Uid)
		}
	}
	if roleStr, ok := ctx.Value(CtxKeyJwtUserRole).(string); ok {
		role = roleStr
	}
	if emailStr, ok := ctx.Value(CtxKeyJwtUserEmail).(string); ok {
		email = emailStr

	}
	// fmt.Println("user info is ", uid, role, email)
	return &UserCtx{
		UserId: uid,
		Role:   role,
		Email:  email,
	}
}
