package format

import "fmt"

// Seconds 将秒转换为易读的时间格式
func Seconds(seconds float64) string {
	s := int(seconds)

	if s < 60 {
		return fmt.Sprintf("%d秒", s)
	}

	minutes := s / 60
	s %= 60

	if minutes < 60 {
		if s == 0 {
			return fmt.Sprintf("%d分钟", minutes)
		}
		return fmt.Sprintf("%d分钟%d秒", minutes, s)
	}

	hours := minutes / 60
	minutes %= 60

	if hours < 24 {
		if minutes == 0 {
			return fmt.Sprintf("%d小时", hours)
		}
		return fmt.Sprintf("%d小时%d分钟", hours, minutes)
	}

	days := hours / 24
	hours %= 24

	if hours == 0 {
		return fmt.Sprintf("%d天", days)
	}
	return fmt.Sprintf("%d天%d小时", days, hours)
}
