package middleware

import (
	"context"
	"errors"
	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
	"net/http"
	"oa-server/common/ctxdata"
	"oa-server/common/globalkey"
	"oa-server/response"
	"time"
)

type AuthMiddleware struct {
	lbkUcClient *lbkUc.LbkUserClient
	AppName     string
}

func NewAuthMiddleware(appName string, client *lbkUc.LbkUserClient) *AuthMiddleware {
	return &AuthMiddleware{AppName: appName, lbkUcClient: client}
}

func (m *AuthMiddleware) Handle(next http.HandlerFunc) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		token := r.Header.Get(globalkey.HeaderKeyToken)
		if token == "" {
			response.ErrorWithData(w, errors.New("token缺失"), map[string]any{"reload": true})
			return
		}

		// 校验用户token
		checkReq := lbkUc.CheckJWTReq{AppName: m.AppName, Token: token}
		checkResp, err := m.lbkUcClient.CheckJwtToken(context.Background(), checkReq)
		if err != nil {
			// zhoubao 20250716 暂时屏蔽掉这个错误，因为usercenter的错误码还没统一
			//if errors.Is(err, lbkUc.ErrUserServiceFailed) {
			//	logx.Infow("usercenter response biz code is not 200", logx.Field("message", err))
			//	response.ErrorWithData(w, err, map[string]any{"reload": true})
			//	return
			//}
			logx.Errorw("failed to call usercenter.CheckJwtToken", logx.Field("error", err))
			// response.Error(w, err)
			response.ErrorWithData(w, err, map[string]any{"reload": true})
			return
		}
		if time.Unix(checkResp.ExpiresAt, 0).Before(time.Now()) {
			logx.Infow("token expired", logx.Field("token", token))
			response.ErrorWithData(w, err, map[string]any{"reload": true})
			return
		}

		ctx := context.WithValue(r.Context(), ctxdata.CtxKeyJwtUserEmail, checkResp.UserInfo.Email)
		ctx = context.WithValue(ctx, ctxdata.CtxKeyJwtUserInfo, checkResp.UserInfo)
		r = r.WithContext(ctx)

		next(w, r)
	}
}
