package msgcenter

import "encoding/json"

const (
	LarkReceiveIdTypeEmail   = "email"
	LarkReceiveIdTypeOpenId  = "open_id"
	LarkReceiveIdTypeUnionId = "union_id"
	LarkReceiveIdTypeUserId  = "user_id"
	LarkReceiveIdTypeChatId  = "chat_id"

	LarkMsgTypeText = "text"        // 文本消息
	LarkMsgTypeCard = "interactive" // 消息卡片
)

type NewCardContent struct {
	Type string              `json:"type,omitempty"`
	Data *NewCardContentData `json:"data,omitempty"`
}

type NewCardContentData struct {
	TemplateID   string                 `json:"template_id,omitempty"`
	TemplateVars map[string]interface{} `json:"template_variable,omitempty"`
}

func (m *NewCardContent) String() (string, error) {
	bs, err := json.Marshal(m)
	if err != nil {
		return "", err
	}
	return string(bs), nil
}
