package msgcenter

import (
	"testing"

	larkim "github.com/larksuite/oapi-sdk-go/v3/service/im/v1"

	"oa-server/common/globalkey"
)

var ls = LarkService{}

func TestLarkService_BuildCardContent(t *testing.T) {
	vars := map[string]interface{}{"username": "wangming.xie"}
	content, _ := ls.BuildCardContent("ctp_AAr5UIOlblgm", vars)
	t.Log(content)
	if len(content) == 0 {
		t.Error("BuildCardContent error")
	}
}

func TestLarkService_SendCardMessage(t *testing.T) {
	failGroup := make([]interface{}, 0)
	timeGroup := []interface{}{
		map[string]string{"desc": "开始时间", "time": "2023-05-11 11:23:16"},
		map[string]string{"desc": "结束时间", "time": "2023-05-12 11:23:16"},
	}
	item := make(map[string]interface{})
	item["caseName"] = "ID:219 巡检任务名"
	item["statusCode"] = "200"

	item["errMsg"] = "{上上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货上课的还是款到发货课的还是款到发货}"

	failGroup = append(failGroup, item)
	vars := map[string]interface{}{
		"title":       "单元测试推送",
		"total":       "15",
		"success":     "6",
		"fail":        "9",
		"duration":    "45",
		"reportURL":   "www.lbktech.com",
		"atPersons":   "<at email=wangming.xie@lbk.one></at> <at email=kim.yang@lbk.one></at>",
		"group_table": failGroup,
		"group_time":  timeGroup,
	}

	content, _ := ls.BuildCardContent("ctp_AAr5UIOlGRx9", vars) // ctp_AAr5UIOlGRx9 测开的群chat_id
	// EP-雨燕机器人
	// oc_ac94a426a927fce0d4198d2baa99ba34  测开群chat_id
	// oc_e72177387acfdf6a4bf4e460af4a8d8a  生产群chat_id
	// oc_cf5603541dd62fdabcd10781ec487c5e  测试群chat_id
	// oc_71b852a229abee72f4091f3961760be5  域名巡检群chat_id
	err := ls.SendCardMessage(larkim.ReceiveIdTypeChatId, "oc_ac94a426a927fce0d4198d2baa99ba34", larkim.MsgTypeInteractive, content)
	if err != nil {
		t.Error("SendCardMessage error")
	}
}

func TestLarkService_tmp_SendCardMessage(t *testing.T) {
	// EP-雨燕机器人
	// oc_ac94a426a927fce0d4198d2baa99ba34  测开群chat_id
	// oc_e72177387acfdf6a4bf4e460af4a8d8a  生产群chat_id
	// oc_cf5603541dd62fdabcd10781ec487c5e  测试群chat_id
	// oc_71b852a229abee72f4091f3961760be5  域名巡检群chat_id
	content := `{"type":"template","data":{"template_id":"ctp_AArlvpHX7XsW","template_variable":{"expire_3domain":"以下证书7天内过期：\r\napi.lbkex.com\r\n"}}}`
	err := ls.SendCardMessage(larkim.ReceiveIdTypeChatId, "oc_ac94a426a927fce0d4198d2baa99ba34", larkim.MsgTypeInteractive, content)
	if err != nil {
		t.Error("SendCardMessage error")
	}
}

func TestLarkSendByEmail(t *testing.T) {
	vars := map[string]interface{}{
		"appName": "app",
		"env":     "test",
		"ip":      "127.0.0.1",
		"demo":    "11111",
	}
	content, _ := ls.BuildCardContent(globalkey.LarkTemplateIDForAPPBindHostResult, vars)
	err := ls.SendCardMessage(larkim.ReceiveIdTypeEmail, "weijia.zhang@lbk.one", larkim.MsgTypeInteractive, content)

	if err != nil {
		t.Error("SendCardMessage error")
	}

}
