package tool

import "github.com/zeromicro/go-zero/core/logx"

func GoSafe(fn func()) {
	go func() {
		defer func() {
			if err := recover(); err != nil {
				logx.Errorf("panic: %v", err)
			}
		}()
		fn()
	}()
}
