package tool

import (
	"encoding/base64"
	"encoding/json"
	"errors"
	"net/http"
	"strings"

	"oa-server/common/globalkey"
)

type TokenPayload struct {
	UUID        string      `json:"UUID"`
	ID          int         `json:"ID"`
	Username    string      `json:"Username"`
	NickName    string      `json:"NickName"`
	AuthorityId int         `json:"AuthorityId"`
	Email       string      `json:"Email"`
	AuthName    string      `json:"AuthName"`
	Biz         interface{} `json:"Biz"`
	AppName     string      `json:"AppName"`
	BufferTime  int         `json:"BufferTime"`
}

func ParseJwtTokenPayload(r *http.Request) (TokenPayload, error) {
	var payload TokenPayload
	token := r.Header.Get(globalkey.HeaderKeyToken)
	if token == "" {
		return payload, errors.New("token missing")
	}
	tokenArr := strings.Split(token, ".")
	if len(tokenArr) != 3 {
		return payload, errors.New("invalid token")
	}

	payloadBytes, err := base64.RawURLEncoding.DecodeString(tokenArr[1])
	if err != nil {
		return payload, err
	}

	err = json.Unmarshal(payloadBytes, &payload)

	return payload, err
}
