package tool

import "time"

// 需要每年维护一次
// https://zhuanlan.zhihu.com/p/328685389
var nonWorkingDays = []string{
	"2025-01-01", "2025-01-04", "2025-01-05", "2025-01-11", "2025-01-12", "2025-01-18", "2025-01-19", "2025-01-25", "2025-01-28", "2025-01-29", "2025-01-30", "2025-01-31", "2025-02-01", "2025-02-02", "2025-02-03", "2025-02-04", "2025-02-09", "2025-02-15", "2025-02-16", "2025-02-22", "2025-02-23", "2025-03-01", "2025-03-02", "2025-03-08", "2025-03-09", "2025-03-15", "2025-03-16", "2025-03-22", "2025-03-23", "2025-03-29", "2025-03-30", "2025-04-04", "2025-04-05", "2025-04-06", "2025-04-12", "2025-04-13", "2025-04-19", "2025-04-20", "2025-04-26", "2025-05-01", "2025-05-02", "2025-05-03", "2025-05-04", "2025-05-05", "2025-05-10", "2025-05-11", "2025-05-17", "2025-05-18", "2025-05-24", "2025-05-25", "2025-05-31", "2025-06-01", "2025-06-02", "2025-06-07", "2025-06-08", "2025-06-14", "2025-06-15", "2025-06-21", "2025-06-22", "2025-06-28", "2025-06-29", "2025-07-05", "2025-07-06", "2025-07-12", "2025-07-13", "2025-07-19", "2025-07-20", "2025-07-26", "2025-07-27", "2025-08-02", "2025-08-03", "2025-08-09", "2025-08-10", "2025-08-16", "2025-08-17", "2025-08-23", "2025-08-24", "2025-08-30", "2025-08-31", "2025-09-06", "2025-09-07", "2025-09-13", "2025-09-14", "2025-09-20", "2025-09-21", "2025-09-27", "2025-10-01", "2025-10-02", "2025-10-03", "2025-10-04", "2025-10-05", "2025-10-06", "2025-10-07", "2025-10-08", "2025-10-12", "2025-10-18", "2025-10-19", "2025-10-25", "2025-10-26", "2025-11-01", "2025-11-02", "2025-11-08", "2025-11-09", "2025-11-15", "2025-11-16", "2025-11-22", "2025-11-23", "2025-11-29", "2025-11-30", "2025-12-06", "2025-12-07", "2025-12-13", "2025-12-14", "2025-12-20", "2025-12-21", "2025-12-27", "2025-12-28",
}

var nonWorkingDaysSet map[string]struct{}

func init() {
	nonWorkingDaysSet = make(map[string]struct{})
	for _, day := range nonWorkingDays {
		nonWorkingDaysSet[day] = struct{}{}
	}
}

func IsWorkingDay(moment time.Time, location *time.Location) bool {
	_, ok := nonWorkingDaysSet[moment.In(location).Format(time.DateOnly)]
	return !ok
}
