
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `delete_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `del_state` tinyint NOT NULL DEFAULT '0',
  `version` bigint NOT NULL DEFAULT '0' COMMENT '版本号',
  `mobile` char(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '性别 0:男 1:女',
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_mobile` (`mobile`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户表';

-- ----------------------------
-- Table structure for user_auth
-- ----------------------------

CREATE TABLE IF NOT EXISTS `user_auth` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `delete_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `del_state` tinyint NOT NULL DEFAULT '0',
  `version` bigint NOT NULL DEFAULT '0' COMMENT '版本号',
  `user_id` bigint NOT NULL DEFAULT '0',
  `auth_key` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台唯一id',
  `auth_type` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台类型',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_type_key` (`auth_type`,`auth_key`) USING BTREE,
  UNIQUE KEY `idx_userId_key` (`user_id`,`auth_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户授权表';

-- ----------------------------
-- Table structure for x_issues
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_issues` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `content` longtext COLLATE utf8mb4_general_ci NOT NULL COMMENT '内容',
  `severity` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '严重程度',
  `status` int NOT NULL DEFAULT '0' COMMENT '流程状态',
  `process_pos` int NOT NULL DEFAULT '0' COMMENT '当前流程位置',
  `process_id` int NOT NULL DEFAULT '0' COMMENT '当前处理流程id',
  `process_status` int NOT NULL DEFAULT '0' COMMENT '当前处理状态',
  `assigned_to` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分配给',
  `reporter` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '提交人',
  `tester` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责测试',
  `developer` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责研发',
  `product_manager` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责产品',
  `process_approver` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '当前d',
  `process_approver_code` int NOT NULL DEFAULT '0' COMMENT '当前处理角色',
  `affected_version` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '影响版本',
  `fix_version` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修复版本',
  `attachments` longblob NOT NULL COMMENT '附件',
  `labels` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
  `type` int NOT NULL DEFAULT '1' COMMENT '1: issue',
  `custom_params` text COLLATE utf8mb4_general_ci COMMENT '自定义更新参数',
  `create_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_at` int NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='问题记录表';

-- ----------------------------
-- Table structure for x_issues_process
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_issues_process` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '对象Id',
  `issue_id` int NOT NULL DEFAULT '0' COMMENT 'issue id',
  `pos` bigint NOT NULL DEFAULT '0' COMMENT '流程当前步骤',
  `approver` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '处理人',
  `attachments` longblob NOT NULL COMMENT '附件',
  `approver_code` int NOT NULL DEFAULT '0' COMMENT '处理人类型 1 开发 2 开发组长 3 测试 4 测试组长 5 运维 6 项目发布 100 流程结束',
  `status` int NOT NULL DEFAULT '0' COMMENT '流程状态',
  `process_handler` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '流程处理人',
  `remark` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '处理备注',
  `tag` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
  `create_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_at` int NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='问题状态流转表';

-- ----------------------------
-- Table structure for x_review
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_review` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `level` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '故障定级',
  `issue_id` int unsigned DEFAULT NULL COMMENT 'issue_id',
  `scope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '影响范围',
  `review` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '回顾',
  `root_cause` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '故障根因',
  `scheme` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '修复方案',
  `improvement` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '改进方案',
  `kpi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '关联绩效',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '备注',
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '创建人',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间\n',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `idx_owner` (`owner`),
  KEY `idx_level` (`level`),
  KEY `idx_iid` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_review_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_review_user` (
  `email` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户email',
  `rid` int unsigned NOT NULL COMMENT 'review_id',
  UNIQUE KEY `udx_er` (`email`,`rid`) COMMENT '关注',
  KEY `idx_rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for x_user_follow_issue
-- ----------------------------
CREATE TABLE IF NOT EXISTS `x_user_follow_issue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `email` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `issue_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `udx_u_i` (`email`,`issue_id`) COMMENT '用户关注的issue'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户关注issue';

SET FOREIGN_KEY_CHECKS = 1;
