#!/bin/bash
#set -e
cp ~/.netrc .
CODE_DIR="/home/server/data/code/lbk-oa-server"
COMPOSE_FILE="/home/server/data/code/lbk-oa-server/docker-compose.yml"
IMAGE_BASE_NAME="lbk-oa-server"
DATETIME=$(date +%F_%H-%M-%S | sed 's/:/-/g')  # 修正标签格式
NEW_IMAGE_TAG="${IMAGE_BASE_NAME}:${DATETIME}"

echo_info() {
    echo -e "\033[1;34m[$(date '+%Y-%m-%d %H:%M:%S')][INFO]\033[0m \033[1;32m$1\033[0m"
}

echo_warning() {
    echo -e "\033[1;34m[$(date '+%Y-%m-%d %H:%M:%S')][WARNING]\033[0m \033[1;33m$1\033[0m"
}

echo_error() {
    echo -e "\033[1;34m[$(date '+%Y-%m-%d %H:%M:%S')][ERROR]\033[0m \033[1;31m$1\033[0m"
}

echo_info "1. 正在进入代码目录: $CODE_DIR"
cd "$CODE_DIR"

echo_info "2. 拉取 feature/1.0.0 分支最新代码..."
deployStartTime=$(date +%s)
git stash > /dev/null 2>&1
git checkout feature/1.0.0 > /dev/null 2>&1
git pull --rebase > /dev/null 2>&1 || { echo_error "Git 拉取代码失败"; exit 1; }

echo_info "3. 构建 Docker 镜像"
docker build -t "$NEW_IMAGE_TAG" . || { echo_error "Docker 构建失败"; exit 1; }

echo_info "4. 更新 docker-compose 文件中的镜像"
sed -i "s|image: ${IMAGE_BASE_NAME}.*|image: ${NEW_IMAGE_TAG}|" "$COMPOSE_FILE" || { echo_error "更新 docker-compose 文件失败"; exit 1; }

echo_info "5. 启动服务"
docker-compose -f "$COMPOSE_FILE" up -d || { echo_error "启动服务失败"; exit 1; }


COMMIT_ID=$(git rev-parse --short HEAD)
DATETIME=$(date +%F_%H-%M-%S)
DESTINATION_PATH="/apps/ep/repository/${BUILD_FILE}_${DATETIME}_${COMMIT_ID}"

deployTitle=$(git log -1 --pretty=format:'%s')

sleep 15

echo_info "8. 检查 lbk-oa-server 服务端口服务状态..."
if docker ps | grep -q "$IMAGE_BASE_NAME"; then
    echo_info "9. 服务正在运行。"
else
    echo_error "9. 服务未运行。"
fi
#
#deployEndTime=$(date +%s)
#compileDuration=$((deployEndTime-deployStartTime))
#jsonPayload=$(jq -n \
#                  --arg env "test" \
#                  --arg deployTitle "部署成功" \
#                  --arg appName "lbk-oa-server" \
#                  --arg title "${deployTitle}" \
#                  --arg deployTime "$(date -d @$deployStartTime '+%Y-%m-%d %H:%M:%S')" \
#                  --arg atPerson "<at id=all></at>" \
#                  --arg ip "172.19.1.100:8080" \
#                  --arg ipDeployTime "$(date -d @$deployEndTime '+%Y-%m-%d %H:%M:%S')" \
#                  --arg ipDeployDesc "部署成功 耗时 ${compileDuration} 秒" \
#                  '{
#                    tpl_id: "ctp_AAqkzkMsm6QL",
#                    chat_id: "oc_ac94a426a927fce0d4198d2baa99ba34",
#                    params: {
#                      env: $env,
#                      deployTitle: $deployTitle,
#                      appName: $appName,
#                      title: $title,
#                      deployTime: $deployTime,
#                      atPerson: $atPerson,
#                      ip: $ip,
#                      ipDeployTime: $ipDeployTime,
#                      ipDeployDesc: $ipDeployDesc
#                    }
#                  }')
#
#if curl --location --request POST 'https://ccapi.lbktech.com/api/v1/internal/SendLarkMsg' \
#     --header 'Content-Type: application/json' \
#     --data-raw "$jsonPayload" > /dev/null 2>&1
#then
#    echo_info "9. 部署成功, 相关信息已发送飞书群！"
#else
#    echo_warning "飞书通知发送失败。"
#fi