package main

import (
	"database/sql"
	"fmt"
	"log"

	_ "github.com/go-sql-driver/mysql"
)

const (
	dbUser     = "root"
	dbPassword = "123456"
	dbName     = "lbk_oa" // 修改为你想要创建的数据库名称
	dbHost     = "127.0.0.1:13306"
)

func main() {
	dsn := fmt.Sprintf("%s:%s@tcp(%s)/", dbUser, dbPassword, dbHost) // 移除数据库名称，以便首先连接到 MySQL 服务器

	db, err := sql.Open("mysql", dsn)
	if err != nil {
		log.Fatal(err)
	}
	defer db.Close()

	// 创建数据库
	_, err = db.Exec("CREATE DATABASE IF NOT EXISTS " + dbName)
	if err != nil {
		log.Fatal(err)
	}
	fmt.Println("Database created")

	// 切换到新创建的数据库
	dsn = fmt.Sprintf("%s:%s@tcp(%s)/%s", dbUser, dbPassword, dbHost, dbName)
	db, err = sql.Open("mysql", dsn)
	if err != nil {
		log.Fatal(err)
	}

	// 建表语句
	tables := []string{
		`CREATE TABLE IF NOT EXISTS x_issues (
		id bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
		title varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
		content longtext COLLATE utf8mb4_general_ci NOT NULL COMMENT '内容',
		severity varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '严重程度',
		status int NOT NULL DEFAULT '0' COMMENT '流程状态',
		process_pos int NOT NULL DEFAULT '0' COMMENT '当前流程位置',
		process_id int NOT NULL DEFAULT '0' COMMENT '当前处理流程id',
		process_status int NOT NULL DEFAULT '0' COMMENT '当前处理状态',
		assigned_to varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分配给',
		reporter varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '提交人',
		tester varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责测试',
		developer varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责研发',
		product_manager varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '负责产品',
		process_approver varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '当前d',
		process_approver_code int NOT NULL DEFAULT '0' COMMENT '当前处理角色',
		affected_version varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '影响版本',
		fix_version varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修复版本',
		attachments longblob NOT NULL COMMENT '附件',
		labels varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
		type int NOT NULL DEFAULT '1' COMMENT '1: issue',
		custom_params text COLLATE utf8mb4_general_ci COMMENT '自定义更新参数',
		create_at int NOT NULL DEFAULT '0' COMMENT '创建时间',
		update_at int NOT NULL DEFAULT '0' COMMENT '更新时间',
		PRIMARY KEY (id)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='问题记录表';`,
		`CREATE TABLE IF NOT EXISTS x_issues_process (
		id int unsigned NOT NULL AUTO_INCREMENT COMMENT '对象Id',
		issue_id int NOT NULL DEFAULT '0' COMMENT 'issue id',
		pos bigint NOT NULL DEFAULT '0' COMMENT '流程当前步骤',
		approver varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '处理人',
		attachments longblob NOT NULL COMMENT '附件',
		approver_code int NOT NULL DEFAULT '0' COMMENT '处理人类型 1 开发 2 开发组长 3 测试 4 测试组长 5 运维 6 项目发布 100 流程结束',
		status int NOT NULL DEFAULT '0' COMMENT '流程状态',
		process_handler varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '流程处理人',
		remark text COLLATE utf8mb4_general_ci NOT NULL COMMENT '处理备注',
		tag varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
		create_at int NOT NULL DEFAULT '0' COMMENT '创建时间',
		update_at int NOT NULL DEFAULT '0' COMMENT '更新时间',
		PRIMARY KEY (id)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='问题状态流转表';`,
		`CREATE TABLE IF NOT EXISTS x_review (
		id int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
		level varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '故障定级',
		issue_id int unsigned DEFAULT NULL COMMENT 'issue_id',
		scope varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '影响范围',
		review text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '回顾',
		root_cause text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '故障根因',
		scheme text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '修复方案',
		improvement text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '改进方案',
		kpi text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '关联绩效',
		remark text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '备注',
		owner varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '创建人',
		created_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间\n',
		updated_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
		PRIMARY KEY (id),
		KEY idx_owner (owner),
		KEY idx_level (level),
		KEY idx_iid (issue_id)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;`,
		`CREATE TABLE IF NOT EXISTS x_review_user (
		email varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户email',
		rid int unsigned NOT NULL COMMENT 'review_id',
		UNIQUE KEY udx_er (email,rid) COMMENT '关注',
		KEY idx_rid (rid)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;`,
		`CREATE TABLE IF NOT EXISTS x_user_follow_issue (
		id int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
		email varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
		issue_id int unsigned NOT NULL DEFAULT '0',
		PRIMARY KEY (id),
		KEY udx_u_i (email,issue_id) COMMENT '用户关注的issue'
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户关注issue';`,
	}

	// 执行建表语句
	for i, table := range tables {
		fmt.Println("Creating table", i)
		_, err := db.Exec(table)
		if err != nil {
			log.Fatal(err)
		}
	}

	fmt.Println("Tables created successfully")
}
